(*^
::[	Information =

	"This is a Mathematica Notebook file.  It contains ASCII text, and can be
	transferred by email, ftp, or other text-file transfer utility.  It should
	be read or edited using a copy of Mathematica or MathReader.  If you 
	received this as email, use your mail application or copy/paste to save 
	everything from the line containing (*^ down to the line containing ^*)
	into a plain text file.  On some systems you may have to give the file a 
	name ending with ".ma" to allow Mathematica to recognize it as a Notebook.
	The line below identifies what version of Mathematica created this file,
	but it can be opened using any other version as well.";

	FrontEndVersion = "Macintosh Mathematica Notebook Front End Version 2.2";

	MacintoshStandardFontEncoding; 
	
	fontset = title, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e8,  24, "Times"; 
	fontset = subtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, bold, e6,  18, "Times"; 
	fontset = subsubtitle, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeTitle, center, M7, italic, e6,  14, "Times"; 
	fontset = section, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, grayBox, M22, bold, a20,  18, "Times"; 
	fontset = subsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, blackBox, M19, bold, a15,  14, "Times"; 
	fontset = subsubsection, inactive, noPageBreakBelow, nohscroll, preserveAspect, groupLikeSection, whiteBox, M18, bold, R65535, a12,  12, "Times"; 
	fontset = text, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = smalltext, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = input, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeInput, M42, N23, bold, L-5,  10, "Courier"; 
	fontset = output, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = message, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, R65535, L-5,  12, "Courier"; 
	fontset = print, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, L-5,  10, "Courier"; 
	fontset = info, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeOutput, M42, N23, B65535, L-5,  12, "Courier"; 
	fontset = postscript, PostScript, formatAsPostScript, output, inactive, noPageBreakInGroup, nowordwrap, preserveAspect, groupLikeGraphics, M7, l34, w282, h287,  12, "Courier"; 
	fontset = name, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7, italic,  10, "Geneva"; 
	fontset = header, inactive, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = leftheader, inactive, L2,  12, "Times"; 
	fontset = footer, inactive, noKeepOnOnePage, preserveAspect, center, M7,  12, "Times"; 
	fontset = leftfooter, inactive, L2,  12, "Times"; 
	fontset = help, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  10, "Times"; 
	fontset = clipboard, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = completions, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special1, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special2, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special3, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special4, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	fontset = special5, inactive, nohscroll, noKeepOnOnePage, preserveAspect, M7,  12, "Times"; 
	paletteColors = 128; automaticGrouping; currentKernel; 
]
:[font = title; inactive; preserveAspect; startGroup]
Example of RSA Public Key Cryptography
:[font = subsubtitle; inactive; preserveAspect]
Colin P. Williams 
:[font = section; inactive; locked; preserveAspect; startGroup]
Copyright Notice
:[font = text; inactive; locked; preserveAspect; endGroup]
Copyright Colin P. Williams (1997).

This Notebook is intended to be used in conjunction with "Explorations in Quantum Computing" by Colin P. Williams and Scott H. Clearwater, TELOS, Springer-Verlag (1997), ISBN:0-387-94768-X. Permission is hereby granted to copy and distribute this Notebook freely for any non-commercial activity provided you include this copyright notice at the beginning of all such copies. Please send suggestions and bug reports to Colin P. Williams at 
        colin@solstice.jpl.nasa.gov      (818) 306 6512 or 
        cpw@cs.stanford.edu               (415) 728 2118
For information on "Explorations in Quantum Computing" check out the TELOS web site:  http://www.telospub.com/catalog/PHYSICS/Explorations.html. To order call 1-800-777-4643.

All other rights reserved.
:[font = section; inactive; preserveAspect; startGroup]
How to use this Notebook
:[font = text; inactive; preserveAspect]
This Notebook contains code that implements the RSA Public Key Cryptography algorithm (see "Explorations in Quantum Computing", Chapter 6).  You can use this software to explore the details of how the RSA algorithm works.  Note that RSA codes based on sufficiently large keys are very hard to crack on classical computers but would be very easy to crack on quantum computers (assuming anyone could build such a device).  The crux of the matter, concerns the difficulty of factoring the large integer n (the product of two large primes p and q) that is used in the RSA algorithm.  If you know the factors of n (i.e. p and q) you can unscramble the message easily using efficient classical algorithms.  However, to obtain the factors using a classical computer is effectively intractable (as far as is known).  By contrast Peter Shor discovered a fast quantum algorithm for performing the necessary factorization of n.  So a quantum computer renders the RSA scheme vulnerable to attack.  This is important because the RSA scheme is currently the most widely used cryptographic scheme for secure communications.  See Chapter 6 for complete details. 

Please note that all active components of our implementation of the RSA cryptosystem have been deleted from this CD-ROM to ensure compliance with U.S. Federal Law regarding Department of Commerce prohibitions on the export of cryptographic software.  The examples below are sufficient to illustrate the general principles behind RSA Public Kep Cryptography but they will not permit you to generate any new examples for yourself. We may be able to export the active code components of the RSA simulator in the future subject to U.S. government approval.

The following commands are (or rather "were") available in this Notebook:
:[font = input; preserveAspect]
CreatePublicKeyAndPrivateKey
EncryptRSA
DecryptRSA
:[font = text; inactive; preserveAspect]
You can use query (?) to find out how to use them.
:[font = input; preserveAspect; startGroup]
?CreatePublicKeyAndPrivateKey
:[font = print; inactive; preserveAspect; endGroup]
CreatePublicKeyAndPrivateKey[nDigits] creates a matching public key and private key
   based on an integer with roughly nDigits. These keys can then be used as the basis
   for establishing secure communications over a public channel using the RSA
   cryptosystem.
:[font = input; preserveAspect; startGroup]
?EncryptRSA
:[font = print; inactive; preserveAspect; endGroup]
EncryptRSA[message, $PublicKey] creates an RSA encryption of the given message string
   using the public key, $PublicKey. $PublicKey, and its matching private key,
   $PrivateKey, are created using the function CreatePublicKeyAndPrivateKey.
:[font = input; preserveAspect; startGroup]
?DecryptRSA
:[font = print; inactive; preserveAspect; endGroup]
DecryptRSA[cipher, $PrivateKey] decrypts the encrypted message cipher using the
   private key, $PrivateKey. $PrivateKey, and its matching public key, $PublicKey, are
   created using the function CreatePublicKeyAndPrivateKey.
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
To create a public key (the pair {e,n}) and a private key (the pair {d,n}) based on an integer n which has roughly 20 decimal digits, do the following.
:[font = input; preserveAspect; startGroup]
SeedRandom[12345];
{$PublicKey, $PrivateKey} = CreatePublicKeyAndPrivateKey[20]
:[font = print; inactive; preserveAspect]
Picking p: p = 6257493337
Picking q: q = 6356046119
Hence n = p q = 39772916239307209103
Picking large integer d, co-prime to n: d = 5380958597982080231
Computing modular inverse, e, from e d = 1 mod (p-1)(q-1): e = 34928543677329462263
Public  Key is {e, n} = {34928543677329462263, 39772916239307209103}
Private Key is {d, n} = {5380958597982080231, 39772916239307209103}
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
{{34928543677329462263, 39772916239307209103}, 
 
  {5380958597982080231, 39772916239307209103}}
;[o]
{{34928543677329462263, 39772916239307209103}, 
 
  {5380958597982080231, 39772916239307209103}}
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
You can use the public key you created with the CreatePublicKeyAndPrivateKey command to encrypt a message.
:[font = input; preserveAspect; startGroup]
cipherText = EncryptRSA["Here is a secret message!", $PublicKey]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
{21581138220304090677, 6735419423900161318, 14656070734333860517, 
 
  37836439796525544215, 8493526611104820682, 31643097529326638584, 
 
  24188966197022276704, 9984261459086080108, 37632380013932171088, 
 
  9135466893726490912, 18587760351464133513, 19847824799197601467, 
 
  35875467339193717907}
;[o]
{21581138220304090677, 6735419423900161318, 14656070734333860517, 
 
  37836439796525544215, 8493526611104820682, 31643097529326638584, 
 
  24188966197022276704, 9984261459086080108, 37632380013932171088, 
 
  9135466893726490912, 18587760351464133513, 19847824799197601467, 
 
  35875467339193717907}
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
Upon receipt of this message, the intended recipient (who already owns the private key) can decrypt it using the command DecryptRSA.
:[font = input; preserveAspect; startGroup]
DecryptRSA[cipherText, $PrivateKey]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup]
"Here is a secret message!"
;[o]
Here is a secret message!
:[font = subsubsection; inactive; preserveAspect; startGroup]
Try me!
:[font = text; inactive; preserveAspect]
If you want to send a message that contains literal quotation marks, add a leading backslash (i.e. include \" instead of just "). Also, if you want to wrap text onto the next line use a backslash (i.e. a single \ alone).
:[font = input; preserveAspect; startGroup]
cipherText = EncryptRSA["Our next book is called \"Ultimate Zero and \
                         One: Computing at the Edge of Nature\".",
                         $PublicKey]
:[font = output; output; inactive; preserveAspect; endGroup]
{28449394887351054838, 20309977873594138267, 35788942777316477877, 
 
  32706257880145368061, 21376640105731263673, 12515814310468555934, 
 
  25356465966372462285, 22419846478451609105, 10881239137646505327, 
 
  4189619288609140736, 4553858535245731476, 16716614928816581854, 
 
  21199668513993951004, 24867948928438688419, 20635667573977587502, 
 
  30338782169335759551, 7785078759135308564, 4372435421592635675, 
 
  3824945321207306966, 2018537172583222694, 15737846528428402790, 
 
  27114764752896272085, 35788942777316477877, 17660905472642105555, 
 
  29229089794268129403, 884273825642331831, 14472428233212401497, 
 
  17625133666328350954, 23912192753826421406, 30338782169335759551, 
 
  24841783216444229013, 3295900894041022436, 19782830802922313817, 
 
  32692530849560831721, 7785078759135308564, 2448528761549636596, 
 
  2935932729727566345, 30338782169335759551, 7723026894237838852, 
 
  29557638145854992825, 6935087650258942190}
;[o]
{28449394887351054838, 20309977873594138267, 35788942777316477877, 
 
  32706257880145368061, 21376640105731263673, 12515814310468555934, 
 
  25356465966372462285, 22419846478451609105, 10881239137646505327, 
 
  4189619288609140736, 4553858535245731476, 16716614928816581854, 
 
  21199668513993951004, 24867948928438688419, 20635667573977587502, 
 
  30338782169335759551, 7785078759135308564, 4372435421592635675, 
 
  3824945321207306966, 2018537172583222694, 15737846528428402790, 
 
  27114764752896272085, 35788942777316477877, 17660905472642105555, 
 
  29229089794268129403, 884273825642331831, 14472428233212401497, 
 
  17625133666328350954, 23912192753826421406, 30338782169335759551, 
 
  24841783216444229013, 3295900894041022436, 19782830802922313817, 
 
  32692530849560831721, 7785078759135308564, 2448528761549636596, 
 
  2935932729727566345, 30338782169335759551, 7723026894237838852, 
 
  29557638145854992825, 6935087650258942190}
:[font = input; preserveAspect; startGroup]
DecryptRSA[cipherText, $PrivateKey]
:[font = output; output; inactive; preserveAspect; endGroup; endGroup; endGroup; endGroup]
"Our next book is called \"Ultimate Zero and One: Computing at the Edge of\
 
  Nature\"."
;[o]
Our next book is called "Ultimate Zero and One: Computing at the Edge of Nature".
^*)
